/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.util.ModelUtil;

class MultiProviderPicker
extends DBObjectProviderPicker {
    private final DBUIResourceHelper m_helper = new DBUIResourceHelper("MultiProviderPicker");
    private final List<DatabaseUIExtensionHook.ProviderPickerHash> m_pickers;
    private final MultiPanel m_multiProviderPicker = new MultiPanel();
    private final Map<JRadioButton, DBObjectProviderPicker> m_buttons = new HashMap<JRadioButton, DBObjectProviderPicker>();
    private DBObjectProviderPicker.PickerListener m_pickerListener;

    public MultiProviderPicker(List<DatabaseUIExtensionHook.ProviderPickerHash> list) {
        this.m_pickers = list;
    }

    @Override
    public Component getComponent() {
        return this.m_multiProviderPicker;
    }

    @Override
    public void setProvider(String string, Object object) {
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> entry : this.m_buttons.entrySet()) {
            DBObjectProviderPicker dBObjectProviderPicker = entry.getValue();
            dBObjectProviderPicker.setProvider(string, object);
            DBObjectProviderID dBObjectProviderID = dBObjectProviderPicker.getProviderID();
            if (dBObjectProviderID == null || !ModelUtil.areEqual((Object)dBObjectProviderID.getType(), (Object)string)) continue;
            entry.getKey().setSelected(true);
            break;
        }
        this.setSelectedPickerVisible();
    }

    @Override
    protected DBObjectProvider getProviderImpl() throws DBException {
        DBObjectProvider dBObjectProvider = null;
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> entry : this.m_buttons.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            dBObjectProvider = entry.getValue().getProvider();
            break;
        }
        return dBObjectProvider;
    }

    @Override
    public DBObjectProviderID getProviderID() {
        DBObjectProviderID dBObjectProviderID = null;
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> entry : this.m_buttons.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            dBObjectProviderID = entry.getValue().getProviderID();
            break;
        }
        return dBObjectProviderID;
    }

    @Override
    protected boolean isAvailable(DBObjectProviderPicker.PickerConfiguration pickerConfiguration) {
        return true;
    }

    @Override
    protected void init(DBObjectProviderPicker.PickerConfiguration pickerConfiguration) {
        Object object;
        String string;
        String string2;
        Object object2;
        Object var2_2 = null;
        String string3 = this.getDefaultProviderType(pickerConfiguration);
        String string4 = pickerConfiguration.shouldDisablePickerForDefaultProvider() && ModelUtil.hasLength((String)string3) ? string3 : null;
        for (DatabaseUIExtensionHook.ProviderPickerHash object3 : this.m_pickers) {
            object2 = object3.getProviderType();
            string2 = (String)object2 + "_button";
            string = object3.getLabel();
            object = new JRadioButton();
            this.m_helper.resButton((AbstractButton)object, string, string2);
            DBObjectProviderPicker dBObjectProviderPicker = object3.getProviderPicker();
            dBObjectProviderPicker.init(pickerConfiguration, ((String)object2).equals(string4));
            this.m_buttons.put((JRadioButton)object, dBObjectProviderPicker);
        }
        this.m_multiProviderPicker.init(pickerConfiguration);
        for (Map.Entry entry : this.m_buttons.entrySet()) {
            object2 = (DBObjectProviderPicker)entry.getValue();
            string2 = ((DBObjectProviderPicker)object2).getProviderID();
            string = string2 == null ? null : string2.getType();
            if (!ModelUtil.areEqual((Object)string, (Object)(object = ((DBObjectProviderPicker)object2).getDefaultProviderType(pickerConfiguration)))) continue;
            ((JRadioButton)entry.getKey()).doClick();
            break;
        }
    }

    private void setSelectedPickerVisible() {
        for (Map.Entry<JRadioButton, DBObjectProviderPicker> entry : this.m_buttons.entrySet()) {
            Component component = entry.getValue().getComponent();
            component.setVisible(entry.getKey().isSelected());
        }
    }

    @Override
    protected void addImplementationListener() {
        if (this.m_pickerListener == null) {
            this.m_pickerListener = new MyPickerListener();
        }
        if (this.m_buttons == null) {
            throw new IllegalArgumentException("ProviderPicker must be initialized before adding a PickerListener");
        }
        for (DBObjectProviderPicker dBObjectProviderPicker : this.m_buttons.values()) {
            dBObjectProviderPicker.removePickerListener(this.m_pickerListener);
            dBObjectProviderPicker.addPickerListener(this.m_pickerListener);
        }
    }

    @Override
    protected void removeImplementationListener() {
        for (DBObjectProviderPicker dBObjectProviderPicker : this.m_buttons.values()) {
            dBObjectProviderPicker.removePickerListener(this.m_pickerListener);
        }
    }

    private class MultiPanel
    extends JPanel
    implements ActionListener {
        private JLabel m_label = null;
        private JCheckBox m_cbxControlEnable = null;
        private DBUIResourceHelper m_helper = new DBUIResourceHelper("MultiProviderPicker");
        private boolean m_layoutDone;

        private MultiPanel() {
        }

        protected Component getDefaultFocusComponent() {
            Component component = null;
            for (Map.Entry entry : MultiProviderPicker.this.m_buttons.entrySet()) {
                if (!((JRadioButton)entry.getKey()).isSelected()) continue;
                component = ((DBObjectProviderPicker)entry.getValue()).getComponent();
                break;
            }
            return component;
        }

        private void init(DBObjectProviderPicker.PickerConfiguration pickerConfiguration) {
            if (!this.m_layoutDone) {
                Object object;
                DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this);
                int n = 1;
                String string = pickerConfiguration.getLabel();
                if (pickerConfiguration.getControlEnable()) {
                    this.m_cbxControlEnable = new JCheckBox();
                    if (ModelUtil.hasLength((String)string)) {
                        this.m_helper.resButton(this.m_cbxControlEnable, string, "enable");
                    }
                    ++n;
                    dBUILayoutHelper.add(this.m_cbxControlEnable);
                    this.m_cbxControlEnable.addActionListener(this);
                    object = pickerConfiguration.getControlEnableListener();
                    if (object != null) {
                        this.m_cbxControlEnable.addActionListener((ActionListener)object);
                    }
                } else if (ModelUtil.hasLength((String)string)) {
                    this.m_label = new JLabel(string);
                    ++n;
                    dBUILayoutHelper.add(this.m_label);
                }
                object = new ButtonGroup();
                JRadioButton jRadioButton = null;
                TreeSet treeSet = new TreeSet(new Comparator(){

                    public int compare(Object object, Object object2) {
                        JRadioButton jRadioButton = (JRadioButton)object;
                        JRadioButton jRadioButton2 = (JRadioButton)object2;
                        String string = jRadioButton.getText();
                        String string2 = jRadioButton2.getText();
                        return string.compareTo(string2);
                    }
                });
                treeSet.addAll(MultiProviderPicker.this.m_buttons.keySet());
                for (JRadioButton object2 : treeSet) {
                    ++n;
                    ((ButtonGroup)object).add(object2);
                    dBUILayoutHelper.add(object2);
                    object2.addActionListener(this);
                    if (jRadioButton != null) continue;
                    jRadioButton = object2;
                }
                dBUILayoutHelper.pushLeft();
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.setMarginLeft(16);
                for (Map.Entry entry : MultiProviderPicker.this.m_buttons.entrySet()) {
                    Component component = ((DBObjectProviderPicker)entry.getValue()).getComponent();
                    dBUILayoutHelper.add(component, n, 1, true, false);
                    dBUILayoutHelper.nextRow();
                    component.setVisible(false);
                }
                dBUILayoutHelper.pushUp();
                dBUILayoutHelper.layout();
                jRadioButton.doClick();
                if (pickerConfiguration.getControlEnable()) {
                    this.setPickerEnabled(this.m_cbxControlEnable.isSelected());
                } else {
                    this.setPickerEnabled(true);
                }
                this.m_layoutDone = true;
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            if (this.m_cbxControlEnable != null) {
                this.m_cbxControlEnable.setSelected(bl);
            } else {
                this.setPickerEnabled(bl);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.m_cbxControlEnable) {
                if (this.m_cbxControlEnable.isSelected()) {
                    this.setPickerEnabled(true);
                } else {
                    this.setPickerEnabled(false);
                }
            } else {
                if (MultiProviderPicker.this.m_buttons.keySet().contains(object)) {
                    MultiProviderPicker.this.setSelectedPickerVisible();
                    if (((JRadioButton)object).isSelected()) {
                        DBObjectProviderPicker dBObjectProviderPicker = (DBObjectProviderPicker)MultiProviderPicker.this.m_buttons.get(object);
                        DBObjectProviderID dBObjectProviderID = dBObjectProviderPicker.getProviderID();
                        MultiProviderPicker.this.firePickerChanged(dBObjectProviderID);
                    }
                }
                this.repaint();
            }
        }

        private void setPickerEnabled(boolean bl) {
            if (this.m_label != null) {
                this.m_label.setEnabled(bl);
            }
            for (Map.Entry entry : MultiProviderPicker.this.m_buttons.entrySet()) {
                ((JRadioButton)entry.getKey()).setEnabled(bl);
                ((DBObjectProviderPicker)entry.getValue()).setPickerEnabled(bl);
            }
        }
    }

    private class MyPickerListener
    implements DBObjectProviderPicker.PickerListener {
        private MyPickerListener() {
        }

        @Override
        public void providerChanged(DBObjectProviderID dBObjectProviderID) {
            MultiProviderPicker.this.firePickerChanged(dBObjectProviderID);
        }
    }
}

