/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.util.DBObjectMap;
import oracle.javatools.util.ModelUtil;

public class DBObjectListPicker
extends ListPicker {
    private Collection m_acceptTypes;
    private Map<DBObject, DBObject[]> m_paths;
    private DBObjectRenderer m_renderer;
    private DefaultListModel m_model;
    private boolean m_removeOnShuttle = true;

    public DBObjectListPicker() {
        this(new JList(new DefaultListModel()));
    }

    public DBObjectListPicker(JList jList) {
        super(jList);
        this.m_model = (DefaultListModel)jList.getModel();
        jList.setCellRenderer(this.getRenderer());
    }

    public void setRemoveOnShuttle(boolean bl) {
        this.m_removeOnShuttle = bl;
    }

    public void setAcceptTypes(String[] stringArray) {
        this.m_acceptTypes = stringArray == null ? null : Arrays.asList(stringArray);
    }

    public void addDBObject(DBObject dBObject) {
        this.m_model.addElement(dBObject);
    }

    protected final ListCellRenderer getRenderer() {
        if (this.m_renderer == null) {
            this.m_renderer = new DBObjectRenderer();
            this.m_renderer.setIncludeIcon(true);
        }
        return this.m_renderer;
    }

    protected Transferable[] filterForAdd(Transferable[] transferableArray) {
        if (this.m_acceptTypes != null) {
            ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
            for (int i = 0; i < transferableArray.length; ++i) {
                DBObject dBObject;
                if (!(transferableArray[i] instanceof DBObjectTransferable) || !this.m_acceptTypes.contains((dBObject = ((DBObjectTransferable)transferableArray[i]).getDBObject()).getType())) continue;
                arrayList.add(transferableArray[i]);
            }
            return arrayList.toArray(new Transferable[arrayList.size()]);
        }
        return transferableArray;
    }

    public DefaultListModel getListModel() {
        return this.m_model;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            Class<?> clazz;
            if (dataFlavorArray[i] == null || !ModelUtil.areEqual(clazz = dataFlavorArray[i].getRepresentationClass(), DBObjectTransferable.class)) continue;
            if (this.m_acceptTypes != null) {
                String string = dataFlavorArray[i].getHumanPresentableName();
                if (!this.m_acceptTypes.contains(string)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Object[] objectArray = this.getList().getSelectedValues();
        DataFlavor[] dataFlavorArray = new DataFlavor[objectArray.length];
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            String string = null;
            if (objectArray[i] instanceof DBObject) {
                string = ((DBObject)objectArray[i]).getType();
            } else if (objectArray[i] instanceof SchemaObjectDescriptor) {
                string = ((SchemaObjectDescriptor)objectArray[i]).getType();
            }
            dataFlavorArray[i] = DBObjectTransferable.getDataFlavor(string);
        }
        return dataFlavorArray;
    }

    protected Transferable createTransferable(Object object) {
        if (object instanceof SchemaObjectDescriptor) {
            object = ((SchemaObjectDescriptor)object).getObject();
        }
        if (this.m_paths == null) {
            return new DBObjectTransferable((DBObject)object);
        }
        return new DBObjectTransferable((DBObject)object, this.m_paths.get(object));
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        Transferable[] transferableArray2 = this.filterForAdd(transferableArray);
        for (int i = 0; i < transferableArray2.length; ++i) {
            if (!(transferableArray[i] instanceof DBObjectTransferable)) continue;
            this.cachePath((DBObjectTransferable)transferableArray[i]);
        }
        return super.addSelectedItems(transferableArray2);
    }

    protected void cachePath(DBObjectTransferable dBObjectTransferable) {
        DBObject dBObject = dBObjectTransferable.getDBObject();
        DBObject[] dBObjectArray = dBObjectTransferable.getPath();
        if (this.m_paths == null) {
            this.m_paths = new DBObjectMap();
        }
        this.m_paths.put(dBObject, dBObjectArray);
    }

    public void removeSelectedItems() {
        if (this.m_removeOnShuttle) {
            Object[] objectArray = this.getList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof SchemaObjectDescriptor) {
                    object = ((SchemaObjectDescriptor)object).getObject();
                }
                if (!(object instanceof DBObject) || this.m_paths == null) continue;
                this.m_paths.remove((DBObject)object);
            }
            super.removeSelectedItems();
        }
    }

    public void removeAllSelectableItems() {
        if (this.m_removeOnShuttle) {
            if (this.m_paths != null) {
                this.m_paths.clear();
            }
            super.removeAllSelectableItems();
        }
    }
}

